/*
Copyright (c) 1994-9 Silicon Graphics, Inc.

    Permission to use, copy, modify, distribute, and sell this software and
    its documentation for any purpose is hereby granted without fee, provided
    that (i) the above copyright notice and this permission notice appear in
    all copies of the software and related documentation, and (ii) the name
    "Silicon Graphics" or any other trademark of Silicon Graphics, Inc.
    may not be used in any advertising or publicity relating to the software
    without the specific, prior written permission of Silicon Graphics, Inc.

    THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
    EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
    WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

    IN NO EVENT SHALL SILICON GRAPHICS, INC. BE LIABLE FOR ANY SPECIAL,
    INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
    OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
    WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
    LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
    OF THIS SOFTWARE.

        pro_reloc_stream.c
        $Revision: 1.2 $ $Date: 1999/06/22 16:33:41 $
        $Source: /isms/cmplrs.src/osprey1.0/libdwarf/RCS/pro_reloc_stream.c,v $

        This files contains routines for handling relocation
        information when we are creating stream relocs.
        That is, Elf-independent relocations are being 
	created here.
*/

#include "config.h"
#include "libdwarfdefs.h"
#include <stdio.h>
#include <string.h>
#ifdef HAVE_ELFACCESS_H
#include <elfaccess.h> 
#endif
#include "pro_incl.h"
#include "pro_section.h"
#include "pro_reloc.h"
#include "pro_reloc_stream.h"

/*
	Return DW_DLV_ERROR on malloc error or reltarget_length error.
	Return DW_DLV_OK otherwise



*/
/*ARGSUSED*/


int
_dwarf_pro_reloc_name_stream64(
        Dwarf_P_Debug dbg,
	int     base_sec_index,
        Dwarf_Unsigned offset, /* r_offset of reloc */
        Dwarf_Unsigned symidx,
	enum Dwarf_Rel_Type type,int reltarget_length)
{ 
#if HAVE_ELF64_GETEHDR
        Elf64_Rel *elf64_reloc;
	void *relrec_to_fill;
	int res;
	int rel_type;

	res = _dwarf_pro_reloc_get_a_slot(dbg,base_sec_index,
			&relrec_to_fill);
	if(res != DW_DLV_OK)
		return res;

	
	if(type == dwarf_drt_data_reloc) {
	  if(reltarget_length == dbg->de_offset_size) {
	    rel_type = dbg->de_offset_reloc;
	  } else if (reltarget_length == dbg->de_pointer_size) {
	   rel_type = dbg->de_ptr_reloc;
	  } else {
	   return DW_DLV_ERROR;
	  }
	} else if(type == dwarf_drt_segment_rel) {
	  rel_type = dbg->de_exc_reloc;
	} else {
	  /* We are in trouble: improper use of stream relocations.
	     Someone else will diagnose
	  */
	  rel_type = 0;
	}
	
        elf64_reloc = (Elf64_Rel *)relrec_to_fill;
        elf64_reloc->r_offset = offset;
        Set_REL64_info (*elf64_reloc, symidx,
                rel_type);
        return DW_DLV_OK;

#endif /*#if HAVE_ELF64_GETEHDR*/
}

/*
	Return DW_DLV_ERROR on malloc error or reltarget_length error.
	Return DW_DLV_OK otherwise
	a binary reloc: 32bit ABI
*/
int
_dwarf_pro_reloc_name_stream32(
        Dwarf_P_Debug dbg,
	int     base_sec_index,
        Dwarf_Unsigned offset, /* r_offset of reloc */
        Dwarf_Unsigned symidx,
	enum Dwarf_Rel_Type type,
	int reltarget_length)
{ 
        Elf32_Rel *elf32_reloc;
        void *relrec_to_fill;
        int res;
	int rel_type;

        res = _dwarf_pro_reloc_get_a_slot(dbg,base_sec_index,
                        &relrec_to_fill);
        if(res != DW_DLV_OK)
                return res;
        if(type == dwarf_drt_data_reloc) {
          if(reltarget_length == dbg->de_offset_size) {
            rel_type = dbg->de_offset_reloc;
          } else if (reltarget_length == dbg->de_pointer_size) {
           rel_type = dbg->de_ptr_reloc;
          } else {
           return DW_DLV_ERROR;
          }
	} else if(type == dwarf_drt_segment_rel) {
	  rel_type = dbg->de_exc_reloc;
	} else {
	  /* We are in trouble: improper use of stream relocations.
	     Someone else will diagnose
	  */
	  rel_type = 0;
	}

        elf32_reloc = (Elf32_Rel *)relrec_to_fill;
        elf32_reloc->r_offset = (Elf32_Addr)offset;
        Set_REL32_info (*elf32_reloc, (Dwarf_Word)symidx,
                rel_type);
        return DW_DLV_OK;

	/* get a slot, fill in the slot entry */
}



/*
	Return DW_DLV_OK.
	Never can really do anything: lengths cannot
	be represented as end-start in a stream.

*/
/*ARGSUSED*/
int
_dwarf_pro_reloc_length_stream(
        Dwarf_P_Debug dbg,
	int     base_sec_index,
        Dwarf_Unsigned offset, /* r_offset of reloc */
        Dwarf_Unsigned start_symidx,
	Dwarf_Unsigned end_symidx,
	enum Dwarf_Rel_Type type,
	int reltarget_length)
{ 
	/* get a slot, fill in the slot entry */
        return DW_DLV_OK;
}


/* 
        Ensure each stream is a single buffer and
        add that single buffer to the set of stream buffers.

	By creating a new buffer and copying if necessary.

        Free the input set of buffers if we consolidate.
        Return -1 on error (malloc failure)


        Return DW_DLV_OK on success. Any other return indicates 
	malloc failed.
	
*/
int 
_dwarf_stream_relocs_to_disk(
	Dwarf_P_Debug dbg, 
	Dwarf_Signed *new_sec_count)
{
	unsigned long total_size =0;
	Dwarf_Small *data;
        int sec_index;
	unsigned long i;
	Dwarf_Error err;
	Dwarf_Error *error = &err;

	Dwarf_Signed sec_count = 0;

	Dwarf_P_Per_Reloc_Sect p_reloc = &dbg->de_reloc_sect[0];

	for(i = 0; i < NUM_DEBUG_SECTIONS; ++i, ++p_reloc) {
	    unsigned long ct = p_reloc->pr_reloc_total_count;
	    unsigned len;
	    struct Dwarf_P_Relocation_Block_s *p_blk;
	    struct Dwarf_P_Relocation_Block_s *p_blk_last;
	    Dwarf_P_Per_Reloc_Sect   prb;
	    
	    if(ct == 0) {
		continue;
	    }
	    prb = &dbg->de_reloc_sect[i];
	    len = dbg->de_relocation_record_size;
	    ++sec_count;

	    total_size = ct *len;
	    sec_index =  prb->pr_sect_num_of_reloc_sect;
	    if(sec_index == 0) {
			/* call de_func or de_func_b, getting
			   section number of reloc sec */
		int rel_section_index;
	        Dwarf_Unsigned name_idx;
		int int_name;
		int err;

		if(dbg->de_func_b) {
 	 	  rel_section_index = dbg->de_func_b(
                	 _dwarf_rel_section_names[i],
        	 	/*size*/dbg->de_relocation_record_size , 
			/*type*/SHT_REL, 
			/*flags*/0, 
                	/*link to symtab, which we
				cannot know*/ 0,
			/*info == link to sec rels apply to*/
				dbg->de_elf_sects[i],
        		&name_idx, &err);
		} else {
 	 	  rel_section_index = dbg->de_func(
                	_dwarf_rel_section_names[i],
        	 	/*size*/dbg->de_relocation_record_size , 
			/*type*/SHT_REL, 
			/*flags*/0, 
                	/*link to symtab, which we
				cannot know*/0,
			/*info == link to sec rels apply to*/
				dbg->de_elf_sects[i],
        		&int_name, &err);
			name_idx = int_name;
		}
    		if (rel_section_index == -1) {
		    {_dwarf_p_error(dbg, error, DW_DLE_ELF_SECT_ERR);
                                return(DW_DLV_ERROR);}

    		}
    		prb->pr_sect_num_of_reloc_sect = rel_section_index;
		sec_index = rel_section_index;
	    }
	    GET_CHUNK(dbg,sec_index,data,total_size, &err);
	    p_blk = p_reloc->pr_first_block;

	    /* following loop executes at least once.
		Effects the consolidation to a single
		block or, if already a single block,
		simply copies to the output buffer.
		And frees the input block.
		The new block is in the de_debug_sects list.
	    */
	    while(  p_blk ){

		unsigned long len =
			p_blk->rb_where_to_add_next -
			p_blk->rb_data;

		memcpy(data, p_blk->rb_data,len);


	  	data +=  len;

		p_blk_last = p_blk;
		p_blk      = p_blk->rb_next;

		_dwarf_p_dealloc(dbg,(Dwarf_Small *)p_blk_last);
	    }
	    /* ASSERT: sum of len copied == total_size */

	    /*
	        We have copied the input,  
	        now drop the pointers to it.
	        For debugging, leave the other data untouched.
	    */
	    p_reloc->pr_first_block = 0; 
	    p_reloc->pr_last_block = 0;
	}

	*new_sec_count = sec_count;
	return DW_DLV_OK;
}

