/* 
  Copyright (C) 2000,2004,2005 Silicon Graphics, Inc.  All Rights Reserved.
  Portions Copyright (C) 2009 SN Systems Ltd. All Rights Reserved.
  Portions Copyright (C) 2009 David Anderson. All Rights Reserved.

  This program is free software; you can redistribute it and/or modify it
  under the terms of version 2 of the GNU General Public License as
  published by the Free Software Foundation.

  This program is distributed in the hope that it would be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  Further, this software is distributed without any warranty that it is
  free of the rightful claim of any third person regarding infringement
  or the like.  Any license provided herein, whether implied or
  otherwise, applies only to this software file.  Patent licenses, if
  any, provided herein do not apply to combinations of this program with
  other software, or any other product whatsoever.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write the Free Software Foundation, Inc., 51
  Franklin Street - Fifth Floor, Boston MA 02110-1301, USA.

  Contact information:  Silicon Graphics, Inc., 1500 Crittenden Lane,
  Mountain View, CA 94043, or:

  http://www.sgi.com

  For further information regarding this notice, see:

  http://oss.sgi.com/projects/GenInfo/NoticeExplan

$Header: /plroot/cmplrs.src/v7.4.5m/.RCS/PL/dwarfdump/RCS/tag_common.h,v 1.8 2008/01/23 09:47:59 davea Exp $ */

#ifndef tag_common_INCLUDED
#define tag_common_INCLUDED



/* The following is the magic token used to
   distinguish real tags/attrs from group-delimiters.
   Blank lines have been eliminated by an awk script.
*/
#define MAGIC_TOKEN_VALUE 0xffffffff

/* TAG_TREE.LIST Expected input format

0xffffffff
value of a tag
value of a standard tag that may be a child of that tag
...
0xffffffff
value of a tag
value of a standard tag that may be a child of that tag
...
0xffffffff
...

No blank lines or commentary allowed, no symbols, just numbers.

*/

/* TAG_ATTR.LIST Expected input format 

0xffffffff
value of a tag
value of a standard attribute that follows that tag
...
0xffffffff
value of a tag
value of a standard attribute that follows that tag
...
0xffffffff
...

No blank lines or commentary allowed, no symbols, just numbers.

*/

/* We don't need really long lines: the input file is simple. */
#define MAX_LINE_SIZE 1000

/* 1 more than the highest number in the DW_TAG defines,
 * this is for standard TAGs. Number of rows. */
#define STD_TAG_TABLE_ROWS 0x41
/* Enough entries to have a bit for each standard legal tag. */
#define STD_TAG_TABLE_COLUMNS 2

/* TAG tree common extension maximums. */
#define EXT_TAG_TABLE_ROWS  5
#define EXT_TAG_TABLE_COLS  4

/* The following 2 used in tag_tree.c only. */
#define TAG_TABLE_ROW_MAXIMUM STD_TAG_TABLE_ROWS
#define TAG_TABLE_COLUMN_MAXIMUM  EXT_TAG_TABLE_COLS



/* Number of attributes columns per tag. The array is bit fields,
 * BITS_PER_WORD fields per word. Dense and quick to inspect */
#define COUNT_ATTRIBUTE_STD 4 

#define STD_ATTR_TABLE_ROWS STD_TAG_TABLE_ROWS
#define  STD_ATTR_TABLE_COLUMNS  4
/* tag/attr tree common extension maximums. */
#define EXT_ATTR_TABLE_ROWS 4
#define EXT_ATTR_TABLE_COLS 4

/* The following 2 used in tag_attr.c only. */
#define ATTR_TABLE_ROW_MAXIMUM STD_ATTR_TABLE_ROWS
#define ATTR_TABLE_COLUMN_MAXIMUM  EXT_ATTR_TABLE_COLS

/* Bits per 'int' to mark legal attrs. */
#define BITS_PER_WORD 32

#define IS_EOF 1
#define NOT_EOF 0

static char *tag_name[] = {
  "0x00",
  "0x01 DW_TAG_array_type",
  "0x02 DW_TAG_class_type",
  "0x03 DW_TAG_entry_point",
  "0x04 DW_TAG_enumeration_type",
  "0x05 DW_TAG_formal_parameter",
  "0x06",
  "0x07",
  "0x08 DW_TAG_imported_declaration",
  "0x09",
  "0x0a DW_TAG_label",
  "0x0b DW_TAG_lexical_block",
  "0x0c",
  "0x0d DW_TAG_member",
  "0x0e",
  "0x0f DW_TAG_pointer_type",
  "0x10 DW_TAG_reference_type",
  "0x11 DW_TAG_compile_unit",
  "0x12 DW_TAG_string_type",
  "0x13 DW_TAG_structure_type",
  "0x14",
  "0x15 DW_TAG_subroutine_type",
  "0x16 DW_TAG_typedef",
  "0x17 DW_TAG_union_type",
  "0x18 DW_TAG_unspecified_parameters",
  "0x19 DW_TAG_variant",
  "0x1a DW_TAG_common_block",
  "0x1b DW_TAG_common_inclusion",
  "0x1c DW_TAG_inheritance",
  "0x1d DW_TAG_inlined_subroutine",
  "0x1e DW_TAG_module",
  "0x1f DW_TAG_ptr_to_member_type",
  "0x20 DW_TAG_set_type",
  "0x21 DW_TAG_subrange_type",
  "0x22 DW_TAG_with_stmt",
  "0x23 DW_TAG_access_declaration",
  "0x24 DW_TAG_base_type",
  "0x25 DW_TAG_catch_block",
  "0x26 DW_TAG_const_type",
  "0x27 DW_TAG_constant",
  "0x28 DW_TAG_enumerator",
  "0x29 DW_TAG_file_type",
  "0x2a DW_TAG_friend",
  "0x2b DW_TAG_namelist",
  "0x2c DW_TAG_namelist_item",
  "0x2d DW_TAG_packed_type",
  "0x2e DW_TAG_subprogram",
  "0x2f DW_TAG_template_type_parameter",
  "0x30 DW_TAG_template_value_parameter",
  "0x31 DW_TAG_thrown_type",
  "0x32 DW_TAG_try_block",
  "0x33 DW_TAG_variant_part",
  "0x34 DW_TAG_variable",
  "0x35 DW_TAG_volatile_type",
  "0x36 DW_TAG_dwarf_procedure",
  "0x37 DW_TAG_restrict_type",
  "0x38 DW_TAG_interface_type",
  "0x39 DW_TAG_namespace",
  "0x3a DW_TAG_imported_module",
  "0x3b DW_TAG_unspecified_type",
  "0x3c DW_TAG_partial_unit",
  "0x3d DW_TAG_imported_unit",
  "0x3e",			/* was DW_TAG_mutable_type, removed
       				   from DWARF3f. */
  "0x3f DW_TAG_condition",
  "0x40 DW_TAG_shared_type",
};


extern void bad_line_input(char *msg);
extern void trim_newline(char *line, int max);
extern boolean is_blank_line(char *pLine);
extern int read_value(unsigned int *outval,FILE *f);
extern void print_version(string name);
void print_usage_message(char *options[]);
void print_args(int argc, char *argv[]);

#endif /* tag_common_INCLUDED */
